#include <iostream>
#include <vector>
#include <limits.h>
 
using namespace std;
 
int maksimalnaVrednostPodniza(vector<int>& A, vector<int>& B) {
    int maksimalnaVrednost = 0; 
    int n = A.size();
 
    for (int L = 0; L < n; L++) {
        int trenutniXOR = 0; 
        int trenutniAND = INT_MAX; 
 
        for (int R = L; R < n; R++) {
            trenutniXOR ^= A[R]; 
            trenutniAND &= B[R]; 
            int trenutnaVrednost = trenutniXOR * trenutniAND;
            maksimalnaVrednost = max(maksimalnaVrednost, trenutnaVrednost); 
        }
    }
 
    return maksimalnaVrednost;
}
 
int maksimalniXORPodskup(vector<int>& A) {
    int maksimalniXOR = 0; 
    int n = A.size();
 
    for (int i = 0; i < (1 << n); i++) {
        int trenutniXOR = 0; 
        for (int j = 0; j < n; j++) {
            if (i & (1 << j)) {
                trenutniXOR ^= A[j]; 
            }
        }
        maksimalniXOR = max(maksimalniXOR, trenutniXOR); 
    }
 
    return maksimalniXOR;
}
 
int maksimalniANDPodskup(vector<int>& B) {
    int maksimalniAND = 0; 
    int n = B.size();
 
    for (int i = 1; i < (1 << n); i++) {
        int trenutniAND = INT_MAX; 
        for (int j = 0; j < n; j++) {
            if (i & (1 << j)) {
                trenutniAND &= B[j]; 
            }
        }
        maksimalniAND = max(maksimalniAND, trenutniAND); 
    }
 
    return maksimalniAND;
}
 
int main() {
    int N;
 
    cin >> N;
    vector<int> A(N);
    for (int i = 0; i < N; i++) {
        cin >> A[i];
    }
 
    vector<int> B(N);
    for (int i = 0; i < N; i++) {
        cin >> B[i];
    }
 
    int maksimalnaVrednost = maksimalnaVrednostPodniza(A, B);
    cout << maksimalnaVrednost << endl;
 
    return 0;
}